C     E04DBF EXAMPLE PROGRAM TEXT
C     FORTRAN PC50 RELEASE 1. NAG COPYRIGHT 1983.
C
C     .. LOCAL SCALARS ..
      REAL DUM, F, FEST, RR
      INTEGER I, IFAIL, MAXCAL, N, NOUT
C     .. LOCAL ARRAYS ..
      REAL G(2), W(2), X(2), XTOL(2)
C     .. FUNCTION REFERENCES ..
      REAL X02AAF
C     .. SUBROUTINE REFERENCES ..
C     E04DBF
C     ..
      EXTERNAL FUNCT, MONIT
      DATA NOUT /2/
      WRITE (NOUT,99999)
      N = 2
      X(1) = -1.0
      X(2) = 1.0
      XTOL(1) = X02AAF(RR)
      XTOL(2) = XTOL(1)
      FEST = 0.0
      MAXCAL = 100
      IFAIL = 1
      CALL E04DBF(N, X, F, G, XTOL, FEST, DUM, W, FUNCT, MONIT,
     * MAXCAL, IFAIL)
      WRITE (NOUT,99998) F
      WRITE (NOUT,99997) (X(I),I=1,N)
      WRITE (NOUT,99995) (G(I),I=1,N)
      WRITE (NOUT,99996) IFAIL
      STOP
C     END OF E04DBF EXAMPLE
99999 FORMAT (4(1X/), 31H E04DBF EXAMPLE PROGRAM RESULTS/1X)
99998 FORMAT (25H FINAL FUNCTION VALUE IS , F12.4)
99997 FORMAT (13H AT THE POINT, 2F12.4)
99996 FORMAT (22H THIS HAS ERROR NUMBER, I3)
99995 FORMAT (13H GRADIENT IS , 2F12.4)
      END
      SUBROUTINE FUNCT(N, XC, FC, GC)
C     CALLED BY E04DBF EXAMPLE
C     CALCULATES THE VALUES OF FC,GC AND GC AT THE POINT XC
C     .. SCALAR ARGUMENTS ..
      REAL FC
      INTEGER N
C     .. ARRAY ARGUMENTS ..
      REAL GC(N), XC(N)
C     ..
C     .. LOCAL SCALARS ..
      REAL EX
C     .. FUNCTION REFERENCES ..
      REAL EXP
C     ..
      EX = EXP(XC(1))
      FC = EX*(4.0*XC(1)*(XC(1)+XC(2))+2.0*XC(2)*(XC(2)+1.0)+1.0)
      EX = 4.0*EX
      GC(1) = FC + EX*(2.0*XC(1)+XC(2))
      GC(2) = EX*(XC(1)+XC(2)+0.5)
      RETURN
      END
      SUBROUTINE MONIT(N, XC, FC, GC, NCALL)
C     CALLED BY E04DBF EXAMPLE
C     PRINTS OUT VALUES EVERY ITERATION
C     .. SCALAR ARGUMENTS ..
      REAL FC
      INTEGER N, NCALL
C     .. ARRAY ARGUMENTS ..
      REAL GC(N), XC(N)
C     ..
C     .. LOCAL SCALARS ..
      REAL GNORM
      INTEGER I, NOUT
C     .. FUNCTION REFERENCES ..
      REAL SQRT
C     ..
      DATA NOUT /2/
      GNORM = 0.0
      DO 20 I=1,N
         GNORM = GNORM + GC(I)*GC(I)
   20 CONTINUE
      GNORM = SQRT(GNORM)
      WRITE (NOUT,99999) NCALL, FC, GNORM
      WRITE (NOUT,99998) (XC(I),I=1,N)
      RETURN
99999 FORMAT (6H AFTER, I5, 33H    FUNCTION CALLS,  THE VALUE IS,
     * F12.4/19H WITH GRADIENT NORM, 6X, F12.4)
99998 FORMAT (13H AT THE POINT, 2F12.4/)
      END
