C     D02EBF EXAMPLE PROGRAM TEXT
C     FORTRAN PC50 RELEASE 1. NAG COPYRIGHT 1983.
C
C     .. SCALARS IN COMMON ..
      REAL H, XEND
      INTEGER I
C     ..
C     .. LOCAL SCALARS ..
      REAL TOL, X
      INTEGER IFAIL, IR, IW, J, MPED, N, NOUT
C     .. LOCAL ARRAYS ..
      REAL W(3,21), Y(3)
C     .. SUBROUTINE REFERENCES ..
C     D02EBF
C     ..
      EXTERNAL FCN, OUT, PEDERV
      COMMON XEND, H, I
      DATA NOUT /2/
      WRITE (NOUT,99996)
      WRITE (NOUT,99994)
      N = 3
      IW = 21
      MPED = 0
      IR = 2
      DO 20 J=2,3
         TOL = 0.5*10.**(-J)
         WRITE (NOUT,99999) TOL
         WRITE (NOUT,99998)
         X = 0.
         XEND = 40.E0
         Y(1) = 1.0
         Y(2) = 0.0
         Y(3) = 0.0
         H = (XEND-X)/8.
         I = 7
         IFAIL = 1
         CALL D02EBF(X, XEND, N, Y, TOL, IR, FCN, MPED, PEDERV,
     *    OUT, W, IW, IFAIL)
         WRITE (NOUT,99997) IFAIL
         IF (TOL.LT.0.) WRITE (NOUT,99995)
   20 CONTINUE
      MPED = 1
      WRITE (NOUT,99993)
      DO 40 J=4,5
         TOL = 10.**(-J)
         WRITE (NOUT,99999) TOL
         WRITE (NOUT,99998)
         X = 0.
         XEND = 40.E0
         Y(1) = 1.0
         Y(2) = 0.0
         Y(3) = 0.0
         H = (XEND-X)/8.
         I = 7
         IFAIL = 1
         CALL D02EBF(X, XEND, N, Y, TOL, IR, FCN, MPED, PEDERV,
     *    OUT, W, IW, IFAIL)
         WRITE (NOUT,99997) IFAIL
         IF (TOL.LT.0.) WRITE (NOUT,99995)
   40 CONTINUE
      STOP
99999 FORMAT (22H0CALCULATION WITH TOL=, E8.1)
99998 FORMAT (40H X AND SOLUTION AT EQUALLY SPACED POINTS)
99997 FORMAT (8H  IFAIL=, I1)
99996 FORMAT (4(1X/), 31H D02EBF EXAMPLE PROGRAM RESULTS/1X)
99995 FORMAT (24H RANGE TOO SHORT FOR TOL)
99994 FORMAT (32H0CALCULATING JACOBIAN INTERNALLY)
99993 FORMAT (31H0CALCULATING JACOBIAN BY PEDERV)
      END
      SUBROUTINE FCN(T, Y, F)
C     .. SCALAR ARGUMENTS ..
      REAL T
C     .. ARRAY ARGUMENTS ..
      REAL F(3), Y(3)
C     ..
      F(1) = -0.04*Y(1) + 1.E4*Y(2)*Y(3)
      F(2) = 0.04*Y(1) - 1.E4*Y(2)*Y(3) - 3.E7*Y(2)*Y(2)
      F(3) = 3.E7*Y(2)*Y(2)
      RETURN
      END
      SUBROUTINE PEDERV(X, Y, PW)
C     .. SCALAR ARGUMENTS ..
      REAL X
C     .. ARRAY ARGUMENTS ..
      REAL PW(3,3), Y(3)
C     ..
      PW(1,1) = -0.04
      PW(1,2) = 1.E4*Y(3)
      PW(1,3) = 1.E4*Y(2)
      PW(2,1) = 0.04
      PW(2,2) = -1.E4*Y(3) - 6.E7*Y(2)
      PW(2,3) = -1.E4*Y(2)
      PW(3,1) = 0.
      PW(3,2) = 6.E7*Y(2)
      PW(3,3) = 0.
      RETURN
      END
      SUBROUTINE OUT(X, Y)
C     .. SCALAR ARGUMENTS ..
      REAL X
C     .. ARRAY ARGUMENTS ..
      REAL Y(3)
C     ..
C     .. SCALARS IN COMMON ..
      REAL H, XEND
      INTEGER I
C     ..
C     .. LOCAL SCALARS ..
      INTEGER J, NOUT
C     ..
      COMMON XEND, H, I
      DATA NOUT /2/
      WRITE (NOUT,99999) X, (Y(J),J=1,3)
      X = XEND - FLOAT(I)*H
      I = I - 1
      RETURN
99999 FORMAT (1H , F7.2, 3E13.5)
      END
