C     D02CBF EXAMPLE PROGRAM TEXT
C     FORTRAN PC50 RELEASE 1. NAG COPYRIGHT 1983.
C
C     .. SCALARS IN COMMON ..
      REAL H, XEND
      INTEGER I
C     ..
C     .. LOCAL SCALARS ..
      REAL PI, TOL, X
      INTEGER IFAIL, IR, J, N, NOUT
C     .. LOCAL ARRAYS ..
      REAL W(3,18), Y(3)
C     .. FUNCTION REFERENCES ..
      REAL X01AAF
C     .. SUBROUTINE REFERENCES ..
C     D02CBF
C     ..
      EXTERNAL FCN, OUT
      COMMON XEND, H, I
      DATA NOUT /2/
      WRITE (NOUT,99996)
      PI = X01AAF(X)
      N = 3
      IR = 0
      DO 20 J=4,5
         TOL = 10.**(-J)
         WRITE (NOUT,99999) TOL
         WRITE (NOUT,99998)
         X = 0.
         XEND = 8.E0
         Y(1) = 0.E0
         Y(2) = 0.5E0
         Y(3) = 0.2E0*PI
         H = (XEND-X)/8.
         I = 7
         IFAIL = 1
         CALL D02CBF(X, XEND, N, Y, TOL, IR, FCN, OUT, W, IFAIL)
         WRITE (NOUT,99997) IFAIL
         IF (TOL.LT.0.) WRITE (NOUT,99995)
   20 CONTINUE
      STOP
99999 FORMAT (22H0CALCULATION WITH TOL=, E8.1)
99998 FORMAT (40H X AND SOLUTION AT EQUALLY SPACED POINTS)
99997 FORMAT (8H  IFAIL=, I1)
99996 FORMAT (4(1X/), 31H D02CBF EXAMPLE PROGRAM RESULTS/1X)
99995 FORMAT (24H RANGE TOO SHORT FOR TOL)
      END
      SUBROUTINE FCN(T, Y, F)
C     .. SCALAR ARGUMENTS ..
      REAL T
C     .. ARRAY ARGUMENTS ..
      REAL F(3), Y(3)
C     ..
C     .. FUNCTION REFERENCES ..
      REAL COS, SIN
C     ..
      F(1) = SIN(Y(3))/COS(Y(3))
      F(2) = -0.032E0*F(1)/Y(2) - 0.02E0*Y(2)/COS(Y(3))
      F(3) = -0.032E0/(Y(2)*Y(2))
      RETURN
      END
      SUBROUTINE OUT(X, Y)
C     .. SCALAR ARGUMENTS ..
      REAL X
C     .. ARRAY ARGUMENTS ..
      REAL Y(3)
C     ..
C     .. SCALARS IN COMMON ..
      REAL H, XEND
      INTEGER I
C     ..
C     .. LOCAL SCALARS ..
      INTEGER J, NOUT
C     ..
      COMMON XEND, H, I
      DATA NOUT /2/
      WRITE (NOUT,99999) X, (Y(J),J=1,3)
      X = XEND - FLOAT(I)*H
      I = I - 1
      RETURN
99999 FORMAT (1H , F7.2, 3E13.5)
      END
