C     D01GBF EXAMPLE PROGRAM TEXT
C     FORTRAN PC50 RELEASE 1. NAG COPYRIGHT 1983.
C
C     .. LOCAL SCALARS ..
      REAL ACC, EPS, FINEST
      INTEGER IFAIL, K, MAXCLS, MINCLS, NDIM, NOUT
C     .. LOCAL ARRAYS ..
      REAL A(4), B(4), WRKSTR(500)
C     .. SUBROUTINE REFERENCES ..
C     D01GBF
C     ..
      EXTERNAL FUNCTN
      DATA NOUT /2/
      WRITE (NOUT,99999)
      NDIM = 4
      DO 20 K=1,NDIM
         A(K) = 0.0
         B(K) = 1.0
   20 CONTINUE
      EPS = .01
      MAXCLS = 20000
      MINCLS = 1000
      IFAIL = 1
      CALL D01GBF(NDIM, A, B, MINCLS, MAXCLS, FUNCTN, EPS, ACC,
     * 500, WRKSTR, FINEST, IFAIL)
      IF (IFAIL.EQ.0) GO TO 40
      WRITE (NOUT,99998) IFAIL
      GO TO 60
   40 WRITE (NOUT,99997) EPS, FINEST, ACC, MINCLS
   60 STOP
99999 FORMAT (4(1X/), 31H D01GBF EXAMPLE PROGRAM RESULTS/1X)
99998 FORMAT (22H0D01GBF FAILS. IFAIL =, I2)
99997 FORMAT (5X, 23HREQUESTED ACCURACY   = , E13.5/5X, 9HESTIMATED,
     * 14H VALUE      = , E13.5/5X, 23HESTIMATED ACCURACY   = ,
     * E13.5/5X, 23HNUMBER OF EVALUATIONS =, I11)
      END
      REAL FUNCTION FUNCTN(NDIM, X)
C     .. SCALAR ARGUMENTS ..
      INTEGER NDIM
C     .. ARRAY ARGUMENTS ..
      REAL X(NDIM)
C     ..
C     .. FUNCTION REFERENCES ..
      REAL EXP
C     ..
      FUNCTN = 4.0*X(1)*X(3)**2*EXP(2.0*X(1)*X(3))/(1.0+X(2)+X(4))**
     * 2
      RETURN
      END
