C     C05NBF EXAMPLE PROGRAM TEXT
C     FORTRAN PC50 RELEASE 1. NAG COPYRIGHT 1983.
C
C     .. LOCAL SCALARS ..
      REAL FNORM, TOL
      INTEGER IFAIL, J, NOUT
C     .. LOCAL ARRAYS ..
      REAL FVEC(9), WA(180), X(9)
C     .. FUNCTION REFERENCES ..
      REAL SQRT, X02AAF
C     .. SUBROUTINE REFERENCES ..
C     C05NBF
C     ..
      EXTERNAL FCN
      DATA NOUT /2/
      WRITE (NOUT,99999)
C     THE FOLLOWING STARTING VALUES PROVIDE A ROUGH SOLUTION.
      DO 20 J=1,9
         X(J) = -1.E0
   20 CONTINUE
      TOL = SQRT(X02AAF(0.0))
      IFAIL = 0
      CALL C05NBF(FCN, 9, X, FVEC, TOL, WA, 180, IFAIL)
      FNORM = 0.0
      DO 40 J=1,9
         FNORM = FNORM + FVEC(J)**2
   40 CONTINUE
      FNORM = SQRT(FNORM)
      WRITE (NOUT,99998) FNORM, IFAIL
      WRITE (NOUT,99997) (X(J),J=1,9)
      STOP
99999 FORMAT (4(1X/), 31H C05NBF EXAMPLE PROGRAM RESULTS/1X)
99998 FORMAT (5X, 31H FINAL L2 NORM OF THE RESIDUALS, E12.4//5X,
     * 15H EXIT PARAMETER, I10//5X, 27H FINAL APPROXIMATE SOLUTION//)
99997 FORMAT (5X, 3E12.4)
      END
      SUBROUTINE FCN(N, X, FVEC, IFLAG)
C     .. SCALAR ARGUMENTS ..
      INTEGER IFLAG, N
C     .. ARRAY ARGUMENTS ..
      REAL FVEC(N), X(N)
C     ..
C     .. LOCAL SCALARS ..
      REAL ONE, TEMP, TEMP1, TEMP2, THREE, TWO, ZERO
      INTEGER K
C     ..
      DATA ZERO, ONE, TWO, THREE /0.E0,1.E0,2.E0,3.E0/
      DO 20 K=1,N
         TEMP = (THREE-TWO*X(K))*X(K)
         TEMP1 = ZERO
         IF (K.NE.1) TEMP1 = X(K-1)
         TEMP2 = ZERO
         IF (K.NE.N) TEMP2 = X(K+1)
         FVEC(K) = TEMP - TEMP1 - TWO*TEMP2 + ONE
   20 CONTINUE
      RETURN
      END
